import os

def hasEvenByteSize(fullFilePath):
    """Funkcja zwraca True, jeżeli plik fullFilePath ma parzystą liczbę bitów, w przeciwnym przypadku 
    funkcja zwraca False"""
    fileSize = os.path.getsize(fullFilePath)
    return fileSize % 2 == 0


def hasEveryVowel(fullFilePath):
    """Funkcja zwraca True, jeżeli nazwa pliku z fullFilePath zawiera a, e, i, o oraz u, w przeciwnym przypadku 
    funkcja zwraca False"""
    name = os.path.basename(fullFilePath).lower()
    return ('a' in name) and ('e' in name) and ('i' in name) and ('o' in name) and ('u' in name)


def walk(folder, matchFunc):
    """Funkcja wywołuje funkcję matchFunc na każdym pliku w folderze i znajdujących się w nim podfolderach;
    funkcja zwraca listę plików, dla których matchFunc zwróciła True"""
    matchedFiles = [] # Lista do przechowywania pasujących plików
    folder = os.path.abspath(folder) # Korzystamy z bezwzględnej ścieżki do folderu

    # Pętla po wszystkich plikach i podfolderach w tym katalogu
    for name in os.listdir(folder):
        filepath = os.path.join(folder, name)
        if os.path.isfile(filepath):
            # Wywołanie matchFunc na każdym pliku z katalogu:
            if matchFunc(filepath):
                matchedFiles.append(filepath)
        elif os.path.isdir(filepath):
            # Rekurencyjne wywołania funkcji walk na wszystkich podfolderach
            # Do listy matchedFiles dodajemy wyniki wyszukiwania otrzymane z wywołań rekurencyjnych
            matchedFiles.extend(walk(filepath, matchFunc))
    return matchedFiles


print('Pliki składające się z parzystej liczby bitów:')
print(walk('.', hasEvenByteSize))
print('Pliki, których nazwa zawiera wszystkie samogłoski:')
print(walk('.', hasEveryVowel))
